package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.VariableAdvantage;
import com.hero.ui.widgets.FractionTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class VariableAdvantageDialog extends ModifierDialog {

	private static final long serialVersionUID = 5326652696877600480L;

	FractionTF advantageTF;

	private JLabel advantageLbl;

	public VariableAdvantageDialog(VariableAdvantage mod, boolean isNew,
			GenericObject parent) {
		super(mod, isNew, parent);
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 52;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(5, 5, 5, 5);
		panel.add(advantageLbl, gbc);
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(advantageTF, gbc);

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		advantageTF.addPropertyChangeListener(new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				modifier.setBaseCost(advantageTF.getCurrent()
						* modifier.getLevelCost() / modifier.getLevelValue());
				updateValues();
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		advantageLbl = new JLabel("<html>Advantages that must be taken:</html>");
		advantageTF = new FractionTF(modifier.getBaseCost()
				/ (modifier.getLevelCost() / modifier.getLevelValue()), 10,
				.25, modifier.useMultiplier());
		valueTF.setVisible(false);
		levelsLbl.setVisible(false);
		levelTF.setVisible(false);

	}
}